using System;
using Server;
using Server.Items;
using Server.Spells;
using Server.Network;
using System.Collections;

namespace Server.Mobiles
{
	public class FireLich : BaseCreature
	{
		[Constructable]
		public FireLich() : base(AIType.AI_Necromage, FightMode.Closest, 10, 1, 0.2, 0.4)
		{
			SpeechHue = Utility.RandomDyedHue();
			Hue = Regions.FireRegion.RandomFireHue;
			Female = false;
			BodyValue = 24;
			BaseSoundID = 1001;
			Name = NameList.RandomName("ancient lich");
			Title = "the Fire lich";

			SetStr(516, 605);
			SetDex(106, 115);
			SetInt(266, 305);

			SetHits(2500);
			SetMana(2500);

			SetDamage(10, 25);

			SetDamageType(ResistanceType.Fire, 70);
			SetDamageType(ResistanceType.Physical, 15);
			SetDamageType(ResistanceType.Energy, 15);

			SetResistance(ResistanceType.Physical, 50, 70);
			SetResistance(ResistanceType.Fire, 100);
			SetResistance(ResistanceType.Cold, 20, 50);
			SetResistance(ResistanceType.Poison, 50, 60);
			SetResistance(ResistanceType.Energy, 40, 70);

			SetSkill(SkillName.EvalInt, 77.6, 110.5);
			SetSkill(SkillName.Necromancy, 120.6, 130.5);
			SetSkill(SkillName.SpiritSpeak, 120.1, 150.5);
			SetSkill(SkillName.Magery, 90.1, 120.1);
			SetSkill(SkillName.Poisoning, 80.5);
			SetSkill(SkillName.Meditation, 110.0);
			SetSkill(SkillName.MagicResist, 80.1, 85.0);
			SetSkill(SkillName.Parry, 90.1, 95.1);
			SetSkill(SkillName.Tactics, 100.0);
			SetSkill(SkillName.Wrestling, 90.1, 120.0);

			Fame = 10000;
			Karma = -15000;

			VirtualArmor = 65;

			PackNecroReg(50, 100);

			if (Utility.RandomDouble() < 0.2)
				PackItem(new RandomTalisman());

			AddItem(new NecromancerSpellbook((UInt64)0xFFFF));
			PackItem(Loot.RandomNewPotion());
			PackItem(Loot.RandomScroll(1, 4, SpellbookType.Necromancer));
		}

		public override void GenerateLoot()
		{
			AddLoot(LootPack.UltraRich, 2);
			AddLoot(LootPack.Rich, 2);
			AddLoot(LootPack.HighScrolls, 4);
		}

		public override bool CanRummageCorpses { get { return true; } }
		public override bool AlwaysMurderer { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		public override Poison PoisonImmune { get { return Poison.Deadly; } }
		public override int TreasureMapLevel { get { return 5; } }
		public override bool BleedImmune { get { return true; } }
		public override bool IsNotScaredOfDeath { get { return true; } } //neutika pri malem poctu hp

		public void SpawnWraiths(Mobile target)
		{
			Map map = this.Map;

			if (map == null)
				return;

			int newWraiths = Utility.RandomMinMax(2, 5);

			for (int i = 0; i < newWraiths; ++i)
			{
				BlackLichWraith wraith = new BlackLichWraith();

				wraith.Team = this.Team;
				wraith.FightMode = FightMode.Closest;
				wraith.Hue = Regions.FireRegion.RandomFireHue;
				wraith.Name = "a fire wraith";
				wraith.SetResistance(ResistanceType.Fire, 100);
				// 				wraith.Summoned = true;
				// 			   wraith.SummonMaster = this;

				bool validLocation = false;
				Point3D loc = this.Location;

				for (int j = 0; !validLocation && j < 10; ++j)
				{
					int x = X + Utility.Random(3) - 1;
					int y = Y + Utility.Random(3) - 1;
					int z = map.GetAverageZ(x, y);

					if (validLocation = map.CanFit(x, y, this.Z, 16, false, false))
						loc = new Point3D(x, y, Z);
					else if (validLocation = map.CanFit(x, y, z, 16, false, false))
						loc = new Point3D(x, y, z);
				}

				wraith.MoveToWorld(loc, map);
				wraith.Combatant = null;
			}
		}

		public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
		{
			base.OnDamage(amount, from, willKill, typ);

			if (from == null)
				return;

			if(0.1 > Utility.RandomDouble())
			{
				ExpireTimer timer = (ExpireTimer)m_Table[from];

				if(timer == null)
				{
					this.PublicOverheadMessage(MessageType.Regular, 193, true, String.Format("Incinerate on {0}!", from.RawName));
					this.PlaySound(1002);
					timer = new ExpireTimer(from, this);
					timer.Start();
					m_Table[from] = timer;
				}
			}
		}

		public override void OnGaveMeleeAttack(Mobile defender)
		{
			base.OnGaveMeleeAttack(defender);

			if(0.1 > Utility.RandomDouble())
				SpawnWraiths(defender);

				// 			defender.Damage( Utility.Random( 20, 10 ), this );
			defender.Stam -= Utility.Random(5, 15);
			defender.Mana -= Utility.Random(5, 20);
		}

		/*public override void OnGotMeleeAttack( Mobile attacker )
		{
			base.OnGotMeleeAttack( attacker );

			SpawnWraiths( attacker );

		}*/

		private static Hashtable m_Table = new Hashtable();

		private class ExpireTimer : Timer
		{
			private Mobile m_Mobile;
			private Mobile m_From;
			private int m_Count;

			public ExpireTimer(Mobile m, Mobile from)
			: base(TimeSpan.FromSeconds(5.0), TimeSpan.FromSeconds(5.0))
			{
				m_Mobile = m;
				m_From = from;
				Priority = TimerPriority.OneSecond;
			}

			public void DoExpire()
			{
				Stop();
				m_Table.Remove(m_Mobile);
				m_Mobile.SendMessage("Incinerate faded");
			}

			public void DrainLife()
			{
				if(m_Mobile.Alive && !m_Mobile.Blessed && !m_Mobile.Deleted)
				{
					m_Mobile.PlaySound(0x5CA);
					m_Mobile.FixedParticles(0x36BD, 20, 10, 5044, EffectLayer.Head);
					int damage = Engines.XmlSpawner2.XmlSpecial.PercentualDamage(Utility.RandomMinMax(25, 35), m_Mobile);

					m_Mobile.Hits -= damage;
					ISTile5.SendDmgPacket(m_Mobile, damage);

					if (m_Mobile.Hits < 2)
						m_Mobile.Kill();
				}
				else
					DoExpire();
			}

			protected override void OnTick()
			{
				DrainLife();

				if(++m_Count >= 6)
				{
					DoExpire();
					m_Mobile.SendLocalizedMessage(1070824); // The creature's rage subsides.
				}
			}
		}

		public FireLich(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);
			writer.Write((int) 0);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);
			int version = reader.ReadInt();
		}
	}
}